<?php
require 'vendor/autoload.php'; // Adjust the path to your autoload.php file

use Google\Client as Google_Client;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

// Ensure the script only runs on POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo 'Only POST requests are allowed';
    exit;
}

// Get parameters from the POST request
$token1 = $_POST['token'];
$title = $_POST['title'];
$body = $_POST['body'];

function pushNotification($token, $title, $body) {
    $fcmUrl = 'https://fcm.googleapis.com/v1/projects/invescorpapp/messages:send';

    // Get the access token securely using a try-catch block
    try {
        $accessToken = getAccessToken();
    } catch (Exception $e) {
        echo 'Error fetching access token: ' . $e->getMessage();
        return; // Exit the function if access token retrieval fails
    }

    $notification = [
        'message' => [
            'token' => $token,
            'notification' => [
                'title' => $title,
                'body' => $body
            ]
        ]
    ];

    $headers = [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $fcmUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notification));
    $result = curl_exec($ch);
    curl_close($ch);

    echo $result;
}

function getAccessToken() {
    try {
        $client = new Google_Client();
        $client->setAuthConfig('assets/serviceAccountKey.json'); // Replace with the path to your service account JSON file
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->useApplicationDefaultCredentials();

        $accessTokenArray = $client->fetchAccessTokenWithAssertion();
        
        if (isset($accessTokenArray['error'])) {
            throw new Exception('Error fetching access token: ' . $accessTokenArray['error_description']);
        }

        return $accessTokenArray['access_token'];
    } catch (Exception $e) {
        // Handle the exception and log the error
        echo 'Exception caught while getting access token: ' . $e->getMessage();
        throw $e; // Re-throw the exception to be caught in the calling function
    }
}

// Example call
pushNotification($token1, $title, $body);


/*try {
    $factory = (new Factory)->withServiceAccount('assets/serviceAccountKey.json');
    $messaging = $factory->createMessaging();

    $notification = Notification::create($title, $body);

    $message = CloudMessage::withTarget('token', $token1)
        ->withNotification($notification)
        ->withData(['extra_data' => 'extra_value']);

    $messaging->send($message);
    echo 'Notification sent successfully';
} catch (\Exception $e) {
    http_response_code(500); // Internal Server Error
    echo 'Error sending notification: ' . $e->getMessage();
}*/